VERSION 5.00
Begin VB.Form frmTrackDisplaySettings 
   Caption         =   "Track Display Settings:"
   ClientHeight    =   3195
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   3585
   Icon            =   "frmTrackDisplaySettings.frx":0000
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   ScaleHeight     =   3195
   ScaleWidth      =   3585
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame fraSource 
      Caption         =   "Distribution Pane Source"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1695
      Left            =   120
      TabIndex        =   7
      Top             =   1440
      Width           =   3375
      Begin VB.OptionButton optDP 
         Height          =   255
         Index           =   2
         Left            =   2640
         TabIndex        =   10
         Top             =   1320
         Value           =   -1  'True
         Width           =   255
      End
      Begin VB.OptionButton optDP 
         Height          =   255
         Index           =   1
         Left            =   2640
         TabIndex        =   9
         Top             =   960
         Width           =   255
      End
      Begin VB.OptionButton optDP 
         Height          =   255
         Index           =   0
         Left            =   2640
         TabIndex        =   8
         Top             =   600
         Width           =   255
      End
      Begin VB.Line line5 
         X1              =   240
         X2              =   3240
         Y1              =   480
         Y2              =   480
      End
      Begin VB.Label Label8 
         Caption         =   "Histogram"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2160
         TabIndex        =   14
         Top             =   240
         Width           =   855
      End
      Begin VB.Label lblSource 
         Alignment       =   1  'Right Justify
         Caption         =   "Tracks Visible in HRP"
         Height          =   255
         Index           =   2
         Left            =   120
         TabIndex        =   13
         Top             =   1320
         Width           =   1935
      End
      Begin VB.Label lblSource 
         Alignment       =   1  'Right Justify
         Caption         =   "Total Track Count"
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   12
         Top             =   960
         Width           =   1935
      End
      Begin VB.Label lblSource 
         Alignment       =   1  'Right Justify
         Caption         =   "Individual Echoes"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   11
         Top             =   600
         Width           =   1815
      End
   End
   Begin VB.Frame fraTrackColor 
      Caption         =   "Track Display Options"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3375
      Begin VB.CheckBox chkShowHRP 
         Caption         =   "Check1"
         Height          =   255
         Left            =   2640
         TabIndex        =   16
         Top             =   600
         Width           =   255
      End
      Begin VB.CheckBox chkShowLRP 
         Caption         =   "Check1"
         Height          =   255
         Left            =   1680
         TabIndex        =   15
         Top             =   600
         Width           =   255
      End
      Begin VB.Frame Frame3 
         BorderStyle     =   0  'None
         Height          =   735
         Left            =   4090
         TabIndex        =   1
         Top             =   600
         Width           =   375
         Begin VB.OptionButton optHRP 
            Caption         =   "Option1"
            Height          =   195
            Index           =   2
            Left            =   0
            TabIndex        =   3
            Top             =   1200
            Width           =   255
         End
         Begin VB.OptionButton optHRP 
            Caption         =   "Option1"
            Height          =   195
            Index           =   1
            Left            =   360
            TabIndex        =   2
            Top             =   960
            Visible         =   0   'False
            Width           =   255
         End
      End
      Begin VB.Line Line1 
         Index           =   0
         X1              =   240
         X2              =   3240
         Y1              =   480
         Y2              =   480
      End
      Begin VB.Label lblColorOption 
         Alignment       =   1  'Right Justify
         Caption         =   "Show Tracks"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   6
         Top             =   600
         Width           =   1095
      End
      Begin VB.Label Label1 
         Caption         =   "Low Res "
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1440
         TabIndex        =   5
         Top             =   240
         Width           =   855
      End
      Begin VB.Label Label2 
         Caption         =   "High Res "
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2400
         TabIndex        =   4
         Top             =   240
         Width           =   855
      End
   End
   Begin VB.Menu mnuTrackDisplay 
      Caption         =   "&TrackDisplay"
      Begin VB.Menu mnuApply 
         Caption         =   "&Apply"
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuCLose 
         Caption         =   "&Close"
         Shortcut        =   ^W
      End
   End
End
Attribute VB_Name = "frmTrackDisplaySettings"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Compare Text
Option Explicit

Private mLRP As EchoGramClass
Private mHRP As EchoGramClass
Private mDP As DistributionPlotClass

Public Sub Setup(LRP As EchoGramClass, HRP As EchoGramClass, _
                                    DP As DistributionPlotClass)
  On Error GoTo oops:
  
  ' set initial values...
  chkShowLRP.value = vbUnchecked
  chkShowHRP.value = vbUnchecked
  optDP(echoesInHRP).value = True
  
  Set mLRP = LRP
  Set mHRP = HRP
  Set mDP = DP
  
  GetLastUsed
  
  Exit Sub
  
oops:
  ErrorBox
  On Error GoTo oops2:
  Resume Next
  
  Exit Sub
  
oops2:
  ErrorBox
  
End Sub

Private Sub chkShowHRP_Click()
  
  On Error GoTo oops:
  
  ConfigureMenu
  
  Exit Sub
  
oops:
  ErrorBox
  
End Sub

Private Sub chkShowLRP_Click()

  On Error GoTo oops:
  
  ConfigureMenu
  
  Exit Sub
  
oops:
  ErrorBox
  
End Sub

Private Sub mnuApply_Click() ' send values to LRP,HRP and DP

  On Error GoTo oops:
  
  Dim index As Integer
  Dim DP_Option As Integer
  
  ' dp
  For index = optDP.LBound To optDP.UBound
    If (optDP(index).value = True) Then DP_Option = index
  Next index

  mDP.SetTrackingOptions DP_Option

  ' LRP
  mLRP.Set_mShowTracks (chkShowLRP.value = vbChecked)
  ' HRP
  mHRP.Set_mShowTracks (chkShowHRP.value = vbChecked)
  
  ' save values to the parameter DB
  With general.propertyList
    .SetProperty "Tracker_Display:ShowLRP", chkShowLRP.value
    .SetProperty "Tracker_Display:ShowHRP", chkShowHRP.value
    .SetProperty "Tracker_Display:ShowDP", DP_Option
  End With
  
  ConfigureMenu
  
  Exit Sub
  
oops:
  ErrorBox "Problems encounter while applying settings."
  On Error GoTo oops2:
  Resume Next

  Exit Sub
  
oops2:
  ErrorBox "Couldn't apply settings.  (Sorry!)"
  
End Sub

Private Sub mnuClose_Click()

  On Error GoTo oops:
  
  Dim reply As VbMsgBoxResult
  
  If Modified Then
   reply = MsgBox("Would you like to apply your changes before exiting?", vbYesNoCancel, "Question:")
   
   Select Case reply
    Case vbYes ' apply values
     mnuApply_Click
     
    Case vbNo  ' do nothing
     
    Case Else  ' Canceled (or something else) so don't do anything...
     Exit Sub
   End Select
   
  End If
  
  Set mLRP = Nothing
  Set mHRP = Nothing
  Set mDP = Nothing
  
  Hide
  Unload Me
  
  Exit Sub
  
oops:
  ErrorBox

End Sub

Public Sub GetLastUsed()

  On Error GoTo oops:
  
  Dim value As Integer
  value = 0
  
  With general
    chkShowLRP.value = .propertyList.GetProperty("Tracker_Display:ShowLRP", vbUnchecked)
    .propertyList.SetProperty "Tracker_Display:ShowLRP", chkShowLRP.value
    
    chkShowHRP.value = .propertyList.GetProperty("Tracker_Display:ShowHRP", vbUnchecked)
    .propertyList.SetProperty "Tracker_Display:ShowHRP", chkShowHRP.value
    
    value = echoesInHRP
    value = .propertyList.GetProperty("Tracker_Display:ShowDP", echoesInHRP)
    Select Case value
      Case echoesInHRP, totalTracks, trackingInHRP
        ' do nothing
      Case Else
        Debug.Assert (False)
        value = echoesInHRP
    End Select
    .propertyList.SetProperty "Tracker_Display:ShowDP", value
    optDP(value).value = True
  End With
  
  ConfigureMenu
  
  Exit Sub
  
oops:
  StoreError
  Resume Next
  
End Sub

Private Function Modified()

  On Error GoTo oops:
  
  Dim oldShowLRP As Boolean
  Dim oldShowHRP As Boolean
  Dim oldShowDP As Boolean
  
  Modified = True
  
  With general
    If chkShowLRP.value <> .propertyList.GetProperty("Tracker_Display:ShowLRP", vbUnchecked) Then Exit Function
    If chkShowHRP.value <> .propertyList.GetProperty("Tracker_Display:ShowHRP", vbUnchecked) Then Exit Function
    If Not optDP(.propertyList.GetProperty("Tracker_Display:ShowDP", echoesInHRP)).value Then Exit Function
  End With
  
  Modified = False

  Exit Function

oops:
  ErrorBox
  
End Function

Private Sub ConfigureMenu()

  mnuApply.enabled = Modified
  
End Sub

Private Sub optDP_Click(index As Integer)
  
  On Error GoTo oops:
  
  ConfigureMenu
  
  Exit Sub
  
oops:
  ErrorBox
  
End Sub
